--------------------------------------------------------------------------------
--  Copyright(C) 2006 by Xilinx, Inc. All rights reserved.
--  This text/file contains proprietary, confidential
--  information of Xilinx, Inc., is distributed under license
--  from Xilinx, Inc., and may be used, copied and/or
--  disclosed only pursuant to the terms of a valid license
--  agreement with Xilinx, Inc.  Xilinx hereby grants you
--  a license to use this text/file solely for design, simulation,
--  implementation and creation of design files limited
--  to Xilinx devices or technologies. Use with non-Xilinx
--  devices or technologies is expressly prohibited and
--  immediately terminates your license unless covered by
--  a separate agreement.
--
--  Xilinx is providing this design, code, or information
--  "as is" solely for use in developing programs and
--  solutions for Xilinx devices.  By providing this design,
--  code, or information as one possible implementation of
--  this feature, application or standard, Xilinx is making no
--  representation that this implementation is free from any
--  claims of infringement.  You are responsible for
--  obtaining any rights you may require for your implementation.
--  Xilinx expressly disclaims any warranty whatsoever with
--  respect to the adequacy of the implementation, including
--  but not limited to any warranties or representations that this
--  implementation is free from claims of infringement, implied
--  warranties of merchantability or fitness for a particular
--  purpose.
--
--  Xilinx products are not intended for use in life support
--  appliances, devices, or systems. Use in such applications are
--  expressly prohibited.
--
--  This copyright and support notice must be retained as part
--  of this text at all times. (c) Copyright 1995-2006 Xilinx, Inc.
--  All rights reserved.
--------------------------------------------------------------------------------


-- $RCSfile: tcc_enc_802_16e_v2_1_comp.vhd,v $
--
-- Description: Component statement for 802.16e Turbo Convolutional Encoder
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.all;

package tcc_enc_802_16e_v2_1_comp is

--------------------------------------------------------------------------------
-- Component declaration for Coregen
-- Note Generics need to be given default values.
-- Otherwise, XCC Characterization will fail in XST
--------------------------------------------------------------------------------
  component tcc_enc_802_16e_v2_1
    generic	(
        C_FAMILY    :     string  := "virtex2";
        C_HAS_ACLR  :     integer := 1;
        C_HAS_CE    :     integer := 1;
        C_HAS_SCLR  :     integer := 1
        );
    port (
        -- System
        CLK         : in  std_logic;
        ACLR        : in  std_logic;
        SCLR        : in  std_logic;
        CE          : in  std_logic;
        -- Control
        FD_IN       : in  std_logic;
        BLK_SIZE    : in  std_logic_vector(9 downto 0);
        -- Data
        DATA_IN_A   : in  std_logic;
        DATA_IN_B   : in  std_logic;
        -- Status
        RFFD        : out std_logic;
        RDY         : out std_logic;
        BLK_START   : out std_logic;
        BLK_END     : out std_logic;
        -- Data
        SYST_A : out std_logic;
        SYST_B : out std_logic;
        PAR_Y1 : out std_logic;
        PAR_W1 : out std_logic;
        PAR_Y2 : out std_logic;
        PAR_W2 : out std_logic
        );
  end component;

-- The following tells XST that this core is a black box which
-- should be generated by the command given by the value of this attribute.
-- Note the fully qualified SIM (JAVA class) name that forms the basis of the
-- core.
  attribute box_type                                  : string;
  attribute box_type of tcc_enc_802_16e_v2_1          : component is "black_box";
  attribute GENERATOR_DEFAULT                         : string;
  attribute GENERATOR_DEFAULT of tcc_enc_802_16e_v2_1 : component is
    "generatecore com.xilinx.ip.tcc_enc_802_16e_v2_1.tcc_enc_802_16e_v2_1";

END tcc_enc_802_16e_v2_1_comp;
